#include	<stdio.h>

#include	"gnomesort.h"

static void
print_array(const char *title, int n, const int ar[]) {
	int i;

	printf("%s: ", title);
	for (i = 0; i < n; i++) {
		printf(" %d", ar[i]);
	}
	printf("\n");
}

int
main(int argc, char *argv[]) {
	FILE *in = (argc > 1 ? fopen(argv[1], "r") : stdin);
	int ar[1000];
	int n = 0;
	
	if (in == 0) {
		fprintf(stderr, "gnomesort cannot open input file %s\n", argv[1]);
		return 1;
	}

	while (fscanf(in, "%d", &ar[n]) == 1) n++;
	print_array(" input", n, ar);
	
	gnomesort(n, ar);
	
	print_array("sorted", n, ar);
	
	return 0;
}
